﻿<# This form was created using POSHGUI.com  a free online gui designer for PowerShell
.NAME
    IP Scanner
 
Code by Kamencesc // DigichafarFan // Bonus
#>
 
Add-Type -AssemblyName System.Windows.Forms
[System.Windows.Forms.Application]::EnableVisualStyles()
 
$Form                            = New-Object system.Windows.Forms.Form
$Form.ClientSize                 = '400,597'
$Form.text                       = "IP Scanner"
$Form.TopMost                    = $false
 
$TextBox_IP                      = New-Object system.Windows.Forms.TextBox
$TextBox_IP.multiline            = $false
$TextBox_IP.text                 = "000.000.000.000"
$TextBox_IP.width                = 109
$TextBox_IP.height               = 20
$TextBox_IP.location             = New-Object System.Drawing.Point(89,20)
$TextBox_IP.Font                 = 'Microsoft Sans Serif,10'
 
$TextBox_From                        = New-Object system.Windows.Forms.TextBox
$TextBox_From.multiline              = $false
$TextBox_From.width                  = 40
$TextBox_From.height                 = 20
$TextBox_From.location               = New-Object System.Drawing.Point(259,20)
$TextBox_From.Font                   = 'Microsoft Sans Serif,10'
$TextBox_From.Text                   = "1"
 
$Labler1                         = New-Object system.Windows.Forms.Label
$Labler1.text                    = "IP subxarxa"
$Labler1.AutoSize                = $true
$Labler1.width                   = 25
$Labler1.height                  = 10
$Labler1.location                = New-Object System.Drawing.Point(10,20)
$Labler1.Font                    = 'Microsoft Sans Serif,10'
 
$Label1                          = New-Object system.Windows.Forms.Label
$Label1.text                     = "Des de"
$Label1.AutoSize                 = $true
$Label1.width                    = 25
$Label1.height                   = 10
$Label1.location                 = New-Object System.Drawing.Point(209,20)
$Label1.Font                     = 'Microsoft Sans Serif,10'
 
$Label2                          = New-Object system.Windows.Forms.Label
$Label2.text                     = "fins a"
$Label2.AutoSize                 = $true
$Label2.width                    = 25
$Label2.height                   = 10
$Label2.location                 = New-Object System.Drawing.Point(305,19)
$Label2.Font                     = 'Microsoft Sans Serif,10'
 
$TextBox_To                        = New-Object system.Windows.Forms.TextBox
$TextBox_To.multiline              = $false
$TextBox_To.width                  = 40
$TextBox_To.height                 = 20
$TextBox_To.location               = New-Object System.Drawing.Point(348,20)
$TextBox_To.Font                   = 'Microsoft Sans Serif,10'
$TextBox_To.Text                   = "254"
 
$ProgressBar1                    = New-Object system.Windows.Forms.ProgressBar
$ProgressBar1.width              = 294
$ProgressBar1.height             = 20
$ProgressBar1.Anchor             = 'right,bottom,left'
$ProgressBar1.location           = New-Object System.Drawing.Point(9,561)
 
$Button1                         = New-Object system.Windows.Forms.Button
$Button1.text                    = "Vinga"
$Button1.width                   = 60
$Button1.height                  = 30
$Button1.Anchor                  = 'right,bottom'
$Button1.location                = New-Object System.Drawing.Point(326,555)
$Button1.Font                    = 'Microsoft Sans Serif,10'
 
$DataGridView1                   = New-Object system.Windows.Forms.DataGridView
$DataGridView1.width             = 375
$DataGridView1.height            = 487
$DataGridView1.ColumnCount = 3
$DataGridView1.ColumnHeadersVisible = $true
$DataGridView1.Columns[0].Name = "IP"
$DataGridView1.Columns[1].Name = "Nom"
$DataGridView1.Columns[2].Name = "Status"
$DataGridView1.Anchor            = 'top,right,bottom,left'
$DataGridView1.location          = New-Object System.Drawing.Point(10,51)
 
$Form.controls.AddRange(@($TextBox_IP,$TextBox_From,$Labler1,$Label1,$Label2,$TextBox_To,$ProgressBar1,$Button1,$DataGridView1))
 
# Events
 
$Button1.Add_Click({ btnVinga })
$TextBox_To.Add_KeyDown( {
  if ($_.KeyCode -eq "Enter") 
    {
    $Button1.PerformClick()
    }
  }
)
 
# Agafea la IP per la nostre lan
$ethName = "Ethernet" # "Ethernet" sol ser el nom de l'adptador de xarxa principal de Windows
 
$NetInfo = Get-NetAdapter -name $ethName # agafa la informació del dispositiu $ethNAme
$IpInfo = $Netinfo | Get-NetIPAddress | Where AddressFamily -like "IPv4" # agafa la IPv4 del dispositiu $ethName
 
$TextBox_IP.Text = $IpInfo.IPAddress # Desa el valor a la caixa de text que toca
 
Function btnVinga() {
    $DataGridView1.Rows.Clear() # Borrem DataGrid
 
    $ProgressBar1.Value=0 # Barra de progres a 0
     
    $subXarxa = $TextBox_IP.Text | % { ([ipaddress]$_).GetAddressBytes()[0..2] -join '.' } # Seleccionem la subxarxa
 
    # Passem a variables les IPs d'inici i de fi i en calculem el total a recorrer per calcular el %
    $ipFrom = [int]$TextBox_From.Text
    $ipTo = [int]$TextBox_To.Text
    $total = $ipTo - $ipFrom
 
    # iniciem el bucle, no fem servir un foreach per poder gestionar la barra de progrés
    for ($i=$ipFrom; $i -le $ipTo; $i++) {
        $ProgressBar1.value = ( ($i-$ipFrom) / $total ) * 100 # Barra de progrés %
 
        # es guarda el resultat del ping
        $resultat = Get-WmiObject Win32_PingStatus -Filter "Address='$subXarxa.$i' and Timeout=200 and ResolveAddressNames='true'"
 
        # afageix al DataGrid la informació que volem,
        # Address (es podria canviar per IPV4Address) ens diu l'adreça de destí
        # ProtocolAddressResolved retorna el nom de la máquina si escau
        # StatusCode retorna el codi del ping, alguns exemple:
        #
        #      0: Success
        #  11002: Destination Net Unreachable
        #  11003: Destination Host Unreachable
        #  11004: Destination Protocol Unreachable
        #  11005: Destination Port Unreachable
        #  11011: Time Out
 
        $DataGridView1.Rows.Add($resultat.Address,$resultat.ProtocolAddressResolved,$resultat.StatusCode) # Afageix al DataGrid
    }
}
 
# Mostra formulari
[void]$Form.ShowDialog()